<?php
/* Gutenberg support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('dentario_gutenberg_theme_setup')) {
    add_action( 'dentario_action_before_init_theme', 'dentario_gutenberg_theme_setup', 1 );
    function dentario_gutenberg_theme_setup() {
        if (is_admin()) {
            add_filter( 'dentario_filter_required_plugins', 'dentario_gutenberg_required_plugins' );
        }
    }
}

// Check if Instagram Widget installed and activated
if ( !function_exists( 'dentario_exists_gutenberg' ) ) {
    function dentario_exists_gutenberg() {
        return function_exists( 'the_gutenberg_project' ) && function_exists( 'register_block_type' );
    }
}

// Filter to add in the required plugins list
if ( !function_exists( 'dentario_gutenberg_required_plugins' ) ) {
    //add_filter('dentario_filter_required_plugins',    'dentario_gutenberg_required_plugins');
    function dentario_gutenberg_required_plugins($list=array()) {
        if (in_array('gutenberg', (array)dentario_storage_get('required_plugins')))
            $list[] = array(
                'name'         => esc_html__('Gutenberg', 'dentario'),
                'slug'         => 'gutenberg',
                'required'     => false
            );
        return $list;
    }
}