<?php
/**
 * Theme sprecific functions and definitions
 */

/* Theme setup section
------------------------------------------------------------------- */

// Set the content width based on the theme's design and stylesheet.
if ( ! isset( $content_width ) ) $content_width = 1170; /* pixels */

// Add theme specific actions and filters
// Attention! Function were add theme specific actions and filters handlers must have priority 1
if ( !function_exists( 'dentario_theme_setup' ) ) {
	add_action( 'dentario_action_before_init_theme', 'dentario_theme_setup', 1 );
	function dentario_theme_setup() {

        // Add default posts and comments RSS feed links to head
        add_theme_support( 'automatic-feed-links' );

        // Enable support for Post Thumbnails
        add_theme_support( 'post-thumbnails' );

        // Custom header setup
        add_theme_support( 'custom-header', array('header-text'=>false));

        // Custom backgrounds setup
        add_theme_support( 'custom-background');

        // Supported posts formats
        add_theme_support( 'post-formats', array('gallery', 'video', 'audio', 'link', 'quote', 'image', 'status', 'aside', 'chat') );

        // Autogenerate title tag
        add_theme_support('title-tag');

        // Add user menu
        add_theme_support('nav-menus');

        // WooCommerce Support
        add_theme_support( 'woocommerce' );

        // Add wide and full blocks support
        add_theme_support( 'align-wide' );

		// Register theme menus
		add_filter( 'dentario_filter_add_theme_menus',		'dentario_add_theme_menus' );

		// Register theme sidebars
		add_filter( 'dentario_filter_add_theme_sidebars',	'dentario_add_theme_sidebars' );

		// Set options for importer
		add_filter( 'dentario_filter_importer_options',		'dentario_set_importer_options' );

		// Add theme specified classes into the body
		add_filter( 'body_class', 'dentario_body_classes' );

		// Set additional menu wrapper
		add_filter( 'dentario_filter_get_nav_menu',		'dentario_filter_get_nav_menu_with_wrappers' );

		// Add new text strings to core.messages.php
		add_action( 'dentario_action_add_scripts_inline', 'dentario_messages_add_custom_scripts_inline', 11 );

		// Set list of the theme required plugins
		dentario_storage_set('required_plugins', array(
                'booked',
                'essgrids',
                'revslider',
                'tribe_events',
                'trx_utils',
                'visual_composer',
                'woocommerce',
                'wp_gdpr_compliance',
                'contact_form_7'

            )
		);

	}
}


// Add page meta to the head
if (!function_exists('dentario_head_add_page_meta')) {
    add_action('wp_head', 'dentario_head_add_page_meta', 1);
    function dentario_head_add_page_meta() {
        $theme_skin = sanitize_file_name(dentario_get_custom_option('theme_skin'));
        ?>
        <meta charset="<?php bloginfo( 'charset' ); ?>" />
        <meta name="viewport" content="width=device-width, initial-scale=1<?php if (dentario_get_theme_option('responsive_layouts')=='yes') echo ', maximum-scale=1'; ?>">
        <meta name="format-detection" content="telephone=no">

        <link rel="profile" href="http://gmpg.org/xfn/11" />
        <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />

        <?php
        if ( !function_exists('has_site_icon') || !has_site_icon() ) {
            $favicon = dentario_get_custom_option('favicon');
            if (!$favicon) {
                if ( file_exists(dentario_get_file_dir('skins/'.($theme_skin).'/images/favicon.ico')) )
                    $favicon = dentario_get_file_url('skins/'.($theme_skin).'/images/favicon.ico');
                if ( !$favicon && file_exists(dentario_get_file_dir('favicon.ico')) )
                    $favicon = dentario_get_file_url('favicon.ico');
            }
            if ($favicon) {
                ?><link rel="icon" type="image/x-icon" href="<?php echo esc_url($favicon); ?>" /><?php
            }
        }

    }
}


// Add/Remove theme nav menus
if ( !function_exists( 'dentario_add_theme_menus' ) ) {
	//Handler of add_filter( 'dentario_filter_add_theme_menus', 'dentario_add_theme_menus' );
	function dentario_add_theme_menus($menus) {
		//For example:
		//$menus['menu_footer'] = esc_html__('Footer Menu', 'dentario');
		//if (isset($menus['menu_panel'])) unset($menus['menu_panel']);
		return $menus;
	}
}


// Add theme specific widgetized areas
if ( !function_exists( 'dentario_add_theme_sidebars' ) ) {
	//Handler of add_filter( 'dentario_filter_add_theme_sidebars',	'dentario_add_theme_sidebars' );
	function dentario_add_theme_sidebars($sidebars=array()) {
		if (is_array($sidebars)) {
			$theme_sidebars = array(
				'sidebar_main'		=> esc_html__( 'Main Sidebar', 'dentario' ),
				'sidebar_footer'	=> esc_html__( 'Footer Sidebar', 'dentario' )
			);
			if (function_exists('dentario_exists_woocommerce') && dentario_exists_woocommerce()) {
				$theme_sidebars['sidebar_cart']  = esc_html__( 'WooCommerce Cart Sidebar', 'dentario' );
			}
			$sidebars = array_merge($theme_sidebars, $sidebars);
		}
		return $sidebars;
	}
}


// Add theme specified classes into the body
if ( !function_exists('dentario_body_classes') ) {
	//Handler of add_filter( 'body_class', 'dentario_body_classes' );
	function dentario_body_classes( $classes ) {

		$classes[] = 'dentario_body';
		$classes[] = 'body_style_' . trim(dentario_get_custom_option('body_style'));
		$classes[] = 'body_' . (dentario_get_custom_option('body_filled')=='yes' ? 'filled' : 'transparent');
		$classes[] = 'theme_skin_' . trim(dentario_get_custom_option('theme_skin'));
		$classes[] = 'article_style_' . trim(dentario_get_custom_option('article_style'));
		
		$blog_style = dentario_get_custom_option(is_singular() && !dentario_storage_get('blog_streampage') ? 'single_style' : 'blog_style');
		$classes[] = 'layout_' . trim($blog_style);
		$classes[] = 'template_' . trim(dentario_get_template_name($blog_style));
		
		$body_scheme = dentario_get_custom_option('body_scheme');
		if (empty($body_scheme)  || dentario_is_inherit_option($body_scheme)) $body_scheme = 'original';
		$classes[] = 'scheme_' . $body_scheme;

		$top_panel_position = dentario_get_custom_option('top_panel_position');
		if (!dentario_param_is_off($top_panel_position)) {
			$classes[] = 'top_panel_show';
			$classes[] = 'top_panel_' . trim($top_panel_position);
		} else 
			$classes[] = 'top_panel_hide';
		$classes[] = dentario_get_sidebar_class();

		if (dentario_get_custom_option('show_video_bg')=='yes' && (dentario_get_custom_option('video_bg_youtube_code')!='' || dentario_get_custom_option('video_bg_url')!=''))
			$classes[] = 'video_bg_show';

		if (dentario_get_theme_option('page_preloader')!='')
			$classes[] = 'preloader';

		return $classes;
	}
}


//------------------------------------------------------------------------
// One-click import support
//------------------------------------------------------------------------

// Set theme specific importer options
if ( ! function_exists( 'dentario_importer_set_options' ) ) {
    add_filter( 'trx_utils_filter_importer_options', 'dentario_importer_set_options', 9 );
    function dentario_importer_set_options( $options=array() ) {
        if ( is_array( $options ) ) {

            $rtl_slug = is_rtl() ? '-rtl' : '';
            $rtl_subdomen = is_rtl() ? 'rtl.' : '';

            // Save or not installer's messages to the log-file
            $options['debug'] = false;
            // Prepare demo data
            if ( is_dir( DENTARIO_THEME_PATH . 'demo/' . $rtl_slug . '/' ) ) {
                $options['demo_url'] = DENTARIO_THEME_PATH . 'demo/' . $rtl_slug . '/';
            } else {
                $options['demo_url'] = esc_url( dentario_get_protocol().'://demofiles.themerex.net/dentario' . $rtl_slug . '/' ); // Demo-site domain
            }

            // Required plugins
            $options['required_plugins'] =  array(
                'booked',
                'essential-grid',
                'revslider',
                'the-events-calendar',
                'js_composer',
                'woocommerce',
                'contact-form-7'

            );

            $options['theme_slug'] = 'dentario';

            // Set number of thumbnails to regenerate when its imported (if demo data was zipped without cropped images)
            // Set 0 to prevent regenerate thumbnails (if demo data archive is already contain cropped images)
            $options['regenerate_thumbnails'] = 3;
            // Default demo
            $options['files']['default']['title'] = esc_html__( 'Dentario Demo', 'dentario' );
            $options['files']['default']['domain_dev'] = esc_url(dentario_get_protocol().'://'  . $rtl_subdomen . 'dentario.themerex.net'); // Developers domain
            $options['files']['default']['domain_demo']= esc_url(dentario_get_protocol().'://'  . $rtl_subdomen . 'dentario.themerex.net'); // Demo-site domain

        }
        return $options;
    }
}

// Set additional menu wrapper
if ( !function_exists( 'dentario_filter_get_nav_menu_with_wrappers' ) ) {
	function dentario_filter_get_nav_menu_with_wrappers($args) {
		$args['link_before'] = "<span>";
		$args['link_after'] = "</span>";
		return $args;
	}
}

// Add parameters to URL
if (!function_exists('dentario_add_to_url')) {
	function dentario_add_to_url($url, $prm) {
		if (is_array($prm) && count($prm) > 0) {
			$separator = dentario_strpos($url, '?')===false ? '?' : '&';
			foreach ($prm as $k=>$v) {
				$url .= $separator . urlencode($k) . '=' . urlencode($v);
				$separator = '&';
			}
		}
		return $url;
	}
}

// Add new text strings to core.messages.php
if ( !function_exists( 'dentario_messages_add_custom_scripts_inline' ) ) {
	function dentario_messages_add_custom_scripts_inline() {
		echo '<script type="text/javascript">
				jQuery("document").ready (function(){'

		     // Phone mask
		     .  "DENTARIO_STORAGE['phone_mask']		= '^[0-9\\-\\+]{9,15}$';"

		     // Strings for translation
		     . 'DENTARIO_STORAGE["strings"]["phone_not_valid"] = "' . addslashes(esc_html__('Invalid phone number', 'dentario')) . '" ;'
		     . 'DENTARIO_STORAGE["strings"]["phone_empty"] = "' . addslashes(esc_html__('The phone can not be empty', 'dentario')) . '" ;'
		     . 'DENTARIO_STORAGE["strings"]["phone_wrong"] = "' . addslashes(esc_html__('The phone is wrong', 'dentario')) . '" ;'
		     . 'DENTARIO_STORAGE["strings"]["doctor_empty"] = "' . addslashes(esc_html__('Doctor name can not be empty', 'dentario')) . '" ;'
		     . 'DENTARIO_STORAGE["strings"]["doctor_long"] = "' . addslashes(esc_html__('Doctor name too long', 'dentario')) . '" ;'
		     . '});</script>';
	}
}

/* Include framework core files
------------------------------------------------------------------- */
// If now is WP Heartbeat call - skip loading theme core files (to reduce server and DB uploads)
// Remove comments below only if your theme not work with own post types and/or taxonomies
//if (!isset($_POST['action']) || $_POST['action']!="heartbeat") {
	require_once trailingslashit( get_template_directory() ) .'fw/loader.php';
//}

// Add theme required plugins
if ( !function_exists( 'dentario_add_trx_utils' ) ) {
    add_filter( 'trx_utils_active', 'dentario_add_trx_utils' );
    function dentario_add_trx_utils($enable=true) {
        return true;
    }
}
?>